"""
Script for visualizing the paths generated by the SAC model, that are used for evaluation
"""
import agent as agent
import functions as fn
import areafilter as af
import matplotlib.pyplot as plt
from matplotlib.colors import LogNorm
import numpy as np
import matplotlib.cm as cm
import pandas as pd

pop_array = np.genfromtxt('population_1km.csv',delimiter=',')

x_index_min = int(((500000)/1000)-300)
x_index_max = int(((500000)/1000)+300)
y_index_min = int(((500000)/1000)-300)
y_index_max = int(((500000)/1000)+300)

x_array = np.genfromtxt('x_1km.csv',delimiter=',')
y_array = np.genfromtxt('y_1km.csv',delimiter=',')

pop_array = pop_array[y_index_min:y_index_max,x_index_min:x_index_max]

circle_lat = 52.3322
circle_lon = 4.75

bearing = np.arange(0,360,0.5)
distance = np.zeros(720)+275

c_map = cm.get_cmap("Blues").copy()
c_map.set_bad('w')

line_color = 'k'
marker_color = 'k' 

waypoints = pd.read_pickle('latlon_paths_x1.pkl')
num_index = 36

models = ['x025','x05','x1','x2','x4']

num_trajectories = 1

for model in models:
    name = f"sac_models/E_3_256-{model}/model/actor.pt"
    actor = agent.Agent(modelname=name)

    lat_0 = 0
    lon_0 = 0

    lat_1 = 0
    lon_1 = 0

    line = af.poly_arc(circle_lat,circle_lon,20,30,-30)
    fig, ax = plt.subplots(figsize=(15, 15))
    ax.tick_params(left = False, right = False , labelleft = False ,
                    labelbottom = False, bottom = False)
    ax.imshow(pop_array,cmap=c_map,extent=[-300000,300000,-300000,300000],norm=LogNorm(vmin=100,vmax=100000))

    turns = []
    for index in np.arange(num_index):
        # for j in distance:
        for traj in np.arange(num_trajectories):
            make_line = True
            count = 0

            lat = np.array([])
            lon = np.array([])

            x = np.array([])
            y = np.array([])
        
            while make_line:
                if count == 0:
                    lat_0 = waypoints['lat'].iloc[index][0]
                    lon_0 = waypoints['lon'].iloc[index][0]

                    lat = np.append(lat,lat_0)
                    lon = np.append(lon,lon_0)
                    x_, y_ = fn.get_xy(lat_0,lon_0)
                    x = np.append(x,x_)
                    y = np.append(y,y_)

                state = fn.get_state(lat_0, lon_0)
                action = actor.step(state)
                lat_1, lon_1 = np.rad2deg(fn.do_action(action,lat_0,lon_0))
                lat = np.append(lat,lat_1)
                lon = np.append(lon,lon_1)
                x_, y_ = fn.get_xy(lat_1,lon_1)
                x = np.append(x,x_)
                y = np.append(y,y_)
                if count > 35:
                    make_line = False
                if af.checkIntersect(line,lat_0,lon_0,lat_1,lon_1):
                    make_line = False
                
                count += 1
                lat_0 = lat_1
                lon_0 = lon_1
            turns.append(len(x)-2)
            ax.plot(x,y,'k',alpha=1,linewidth=3,color=line_color,marker='',markersize=5,markeredgecolor=marker_color,markerfacecolor=marker_color)
            # ax.plot(x,y,'k',alpha=0.1,linewidth=1,color=line_color,marker='*',markersize=15,markeredgecolor=marker_color,markerfacecolor=marker_color)
    print(model,np.mean(turns))
    fig.savefig(f'output/SAC_3_256_{model}.png',bbox_inches='tight')
    
    plt.close(fig)